#pragma once

#include "Font.h"
#include "Themes.h"
#include "imgui.h"
#include "backends/imgui_impl_android.h"
#include "backends/imgui_impl_opengl3.h"
#include "imgui_internal.h"
#include "ImguiPP.h"
#include "stb_image.h"
#include "Icon_Menu.h"
#include "Notify.h"
using namespace std;
#include "ImGuiExtra.h"
#include "Icon.h"
#include "Iconcpp.h"
#include "font6.h"
#include "fa_solid_900.h"
#include "iconMaterialIcons_Regular.h"
#include "MaterialIcons_Regular.h"
#include "NotoEmoji.h"
#include <ctime>
#include <sstream>
#include <iomanip>
#include <string>
#include <map>
#include <chrono>

static auto startTime = std::chrono::steady_clock::now();
std::chrono::system_clock::time_point lastUpdateTime;
int currentSecond = -1;

// Global State
static int activeTab = 0; 
static bool godMode = false;
static bool oneHit = false;
static bool wallHack = false;
static float speedHack = 10.0f;
static bool espLine = false;
static bool espBox = false;

ImVec4 accentcolor = ImVec4(0.10f, 0.45f, 0.91f, 1.0f); 

using namespace ImGui;

namespace ImGuiX {

    void SetAccentColor(float r, float g, float b, float a) {
        accentcolor = ImVec4(r, g, b, a);
    }

    void SetAccentColor(const ImColor& newColor) {
        accentcolor = newColor.Value;
    }

    std::string GetRuntime() {
        auto now = std::chrono::steady_clock::now();
        auto duration = std::chrono::duration_cast<std::chrono::seconds>(now - startTime).count();
        int hours = duration / 3600;
        int minutes = (duration % 3600) / 60;
        int seconds = duration % 60;
        char buffer[128];
        snprintf(buffer, sizeof(buffer), "%02d:%02d:%02d", hours, minutes, seconds);
        return std::string(buffer);
    }

    bool TabButton(const char* label, bool selected, const ImVec2& size) {
        ImGuiWindow* window = GetCurrentWindow();
        if (window->SkipItems) return false;
        ImGuiContext& g = *GImGui;
        const ImGuiStyle& style = g.Style;
        const ImGuiID id = window->GetID(label);
        const ImVec2 labelSize = CalcTextSize(label, NULL, true);
        ImVec2 pos = window->DC.CursorPos;
        const ImRect bb(pos, ImVec2(pos.x + size.x, pos.y + size.y));
        ItemSize(size, style.FramePadding.y);
        if (!ItemAdd(bb, id)) return false;
        bool hovered, held;
        bool pressed = ButtonBehavior(bb, id, &hovered, &held);
        if (pressed) MarkItemEdited(id);
        auto draw = GetWindowDrawList();
        const ImU32 bgCol = GetColorU32(selected ? ImGuiCol_Button : ImGuiCol_ButtonActive);
        draw->AddRectFilled(bb.Min, bb.Max, bgCol);
        float t = selected ? 1.0f : 0.0f;
        float animSpeed = 0.50f; 
        if (g.LastActiveId == g.CurrentWindow->GetID(label)) {
            float tAnim = ImSaturate(g.LastActiveIdTimer / animSpeed);
            t = selected ? (tAnim) : (0);
        }
        auto textColor = ImGui::GetColorU32(ImLerp(ImVec4(180 / 255.f, 180 / 255.f, 180 / 255.f, 180 / 255.f), accentcolor, t));
        draw->AddText(ImVec2(pos.x + size.x / 2 - labelSize.x / 2, pos.y + size.y / 2 - labelSize.y / 2), textColor, label);
        const float lineHeight = 3.0f;  
        const float lineWidth = size.x;
        const ImU32 lineColor = ImGui::GetColorU32(ImLerp(ImVec4(180 / 255.f, 180 / 255.f, 180 / 255.f, 180 / 255.f), accentcolor, t));
        const float lineY = pos.y + size.y - lineHeight; 
        draw->AddLine(ImVec2(pos.x, lineY), ImVec2(pos.x + lineWidth, lineY), lineColor, lineHeight); 
        return pressed;
    }

    void CenteredText(const char* text) {
        ImVec2 window_size = ImGui::GetWindowSize();
        ImVec2 text_size = ImGui::CalcTextSize(text);
        int x = (window_size.x - text_size.x) / 2;
        int y = static_cast<int>(ImGui::GetCursorPosY());
        ImGui::SetCursorPosX(x);
        ImGui::Text(text);
        ImGui::SetCursorPosY(static_cast<float>(y + text_size.y));
    }

    void NeonLineAnimation(){
      ImVec2 P1, P2;
      ImDrawList* pDrawList;
      const auto& CurrentWindowPos = ImGui::GetWindowPos();
      const auto& pWindowDrawList = ImGui::GetWindowDrawList();
      P1 = ImVec2(1.000f, 1.000f);
      P1.x += CurrentWindowPos.x;
      P1.y += CurrentWindowPos.y;
      P2 = ImVec2(1000.000f, 1.000f);
      P2.x += CurrentWindowPos.x;
      P2.y += CurrentWindowPos.y;
      pDrawList = pWindowDrawList;
      float neonColorR = sin(ImGui::GetTime() * 2.0f) * 0.5f + 0.5f;
      float neonColorG = cos(ImGui::GetTime() * 2.0f) * 0.5f + 0.5f;
      float neonColorB = sin(ImGui::GetTime() * 2.0f) * cos(ImGui::GetTime() * 2.0f) * 0.5f + 0.5f;
      pDrawList->AddLine(P1, P2, ImColor(neonColorR, neonColorG, neonColorB, 1.000f), 3.000f);
    }

    void Line(ImColor color){
      ImVec2 P1, P2;
      ImDrawList* pDrawList;
      const auto& CurrentWindowPos = ImGui::GetWindowPos();
      const auto& pWindowDrawList = ImGui::GetWindowDrawList();
      P1 = ImVec2(1.000f, 1.000f);
      P1.x += CurrentWindowPos.x;
      P1.y += CurrentWindowPos.y;
      P2 = ImVec2(1000.000f, 1.000f);
      P2.x += CurrentWindowPos.x;
      P2.y += CurrentWindowPos.y;
      pDrawList = pWindowDrawList;
      pDrawList->AddLine(P1, P2, color, 3.000f);
    }

    void LineRed(){
      ImVec2 P1, P2;
      ImDrawList* pDrawList;
      const auto& CurrentWindowPos = ImGui::GetWindowPos();
      const auto& pWindowDrawList = ImGui::GetWindowDrawList();
      P1 = ImVec2(1.000f, 1.000f);
      P1.x += CurrentWindowPos.x;
      P1.y += CurrentWindowPos.y;
      P2 = ImVec2(1000.000f, 1.000f);
      P2.x += CurrentWindowPos.x;
      P2.y += CurrentWindowPos.y;
      pDrawList = pWindowDrawList;
      pDrawList->AddLine(P1, P2, ImColor(1.000f, 0.000f, 0.000f, 1.000f), 3.000f);
    }

    void RainbowAnimationLine(float thickness) {
        ImDrawList* draw_list = ImGui::GetWindowDrawList();
        ImVec2 menu_pos = ImGui::GetWindowPos();
        ImVec2 menu_size = ImGui::GetWindowSize();
        static float color_offset = 0.0f; 
        color_offset += 0.004f; 
        ImVec2 end_pos = ImVec2(menu_pos.x + menu_size.x, menu_pos.y + thickness);
        draw_list->AddRectFilledMultiColor(
            menu_pos,
            end_pos,
            ImColor::HSV(ImFmod(color_offset, 1.0f), 1.0f, 1.0f),
            ImColor::HSV(ImFmod(color_offset + 0.25f, 1.0f), 1.0f, 1.0f),
            ImColor::HSV(ImFmod(color_offset + 0.5f, 1.0f), 1.0f, 1.0f),
            ImColor::HSV(ImFmod(color_offset + 0.75f, 1.0f), 1.0f, 1.0f));
    }

    bool VerticalSliderFloat(const char* label, const ImVec2& size, float* v, float v_min, float v_max)
    {
        ImGui::PushID(label);
        ImVec2 pos = ImGui::GetCursorScreenPos();
        ImGui::InvisibleButton(label, size);
        if (ImGui::IsItemActive()) {
            ImGui::SetTooltip("%.3f", *v);
            float delta = ImGui::GetIO().MouseDelta.y;
            float range = v_max - v_min;
            *v -= (delta / size.y) * range;
            *v = ImClamp(*v, v_min, v_max);
        }
        ImGui::GetWindowDrawList()->AddRectFilled(pos, ImVec2(pos.x + size.x, pos.y + size.y), ImGui::GetColorU32(ImGuiCol_FrameBg));
        float fraction = 1.0f - (*v - v_min) / (v_max - v_min);
        float knobPosY = fraction * (size.y - size.x) + size.x / 2; 
        ImGui::GetWindowDrawList()->AddRectFilled(ImVec2(pos.x, pos.y + knobPosY - size.x/2), 
                                                  ImVec2(pos.x + size.x, pos.y + knobPosY + size.x/2), 
                                                  ImGui::GetColorU32(ImGuiCol_SliderGrabActive));
        ImGui::SameLine();
        ImGui::Text(label);
        ImGui::PopID();
        return ImGui::IsItemDeactivatedAfterEdit();
    }

    static void HelpMarker(const char* label, const char* desc, float fontSize)
    {
    	ImGui::Text(label);
    	ImGui::SameLine();
        ImGui::TextDisabled("(?)");
        if (ImGui::IsItemHovered()) {
            ImGui::BeginTooltip();
            ImGui::PushTextWrapPos(ImGui::GetFontSize() * fontSize);
            ImGui::TextUnformatted(desc);
            ImGui::PopTextWrapPos();
            ImGui::EndTooltip();
        }
    }
    	
    void Switch(const char* label, bool* v)
    {
        ImVec2 p = ImGui::GetCursorScreenPos();
        ImDrawList* draw_list = ImGui::GetWindowDrawList();
        ImGuiStyle& style = ImGui::GetStyle();
        float height = ImGui::GetFrameHeight();
        float width = height * 1.55f;
        float radius = height * 0.50f;
        ImGui::InvisibleButton(label, ImVec2(width, height));
        if (ImGui::IsItemClicked()) *v = !*v;
        float t = *v ? 1.0f : 0.0f;
        ImGuiContext& g = *GImGui;
        float ANIM_SPEED = 0.08f;
        if (g.LastActiveId == g.CurrentWindow->GetID(label)) {
            float t_anim = ImSaturate(g.LastActiveIdTimer / ANIM_SPEED);
            t = *v ? (t_anim) : (1.0f - t_anim);
        }
        ImU32 col_bg;
        if (ImGui::IsItemHovered())
            col_bg = ImGui::GetColorU32(ImLerp(style.Colors[ImGuiCol_FrameBgHovered], style.Colors[ImGuiCol_FrameBg], t));
        else
            col_bg = ImGui::GetColorU32(ImLerp(style.Colors[ImGuiCol_FrameBg], style.Colors[ImGuiCol_FrameBgActive], t));
        draw_list->AddRectFilled(p, ImVec2(p.x + width, p.y + height), col_bg, height * 0.5f);
        draw_list->AddCircleFilled(ImVec2(p.x + radius + t * (width - radius * 2.0f), p.y + radius), radius - 1.5f, IM_COL32(255, 255, 255, 255));
        ImGui::SameLine();
        ImGui::Text(label);
    }
    	
    void Date() {
        std::time_t currentTime = std::time(nullptr);
        std::tm* localTime = std::localtime(&currentTime);
        char dateString[12]; 
        std::strftime(dateString, sizeof(dateString), "%Y-%m-%d", localTime);
        ImGui::Text("Current Date: %s", dateString);
    }

    void XClock() {
        std::time_t currentTime = std::time(nullptr);
        std::tm* localTime = std::localtime(&currentTime);
        int currentSec = localTime->tm_sec;
        if (currentSec != currentSecond) {
            lastUpdateTime = std::chrono::system_clock::now();
            currentSecond = currentSec;
        }
        auto now = std::chrono::system_clock::now();
        std::chrono::duration<double> elapsedSeconds = now - lastUpdateTime;
        char timeString[9]; 
        std::strftime(timeString, sizeof(timeString), "%H:%M:%S", localTime);
        ImGui::Text("Current Time: %s", timeString);
        ImGui::Text("Elapsed Time: %.2f seconds", elapsedSeconds.count());
    }

    void RainbowText(const char* text) {
        ImVec4 rainbowColors[] = {
            ImVec4(1.0f, 0.0f, 0.0f, 1.0f),   
            ImVec4(1.0f, 0.5f, 0.0f, 1.0f),   
            ImVec4(1.0f, 1.0f, 0.0f, 1.0f), 
            ImVec4(0.0f, 1.0f, 0.0f, 1.0f), 
            ImVec4(0.0f, 0.0f, 1.0f, 1.0f),  
            ImVec4(0.5f, 0.0f, 0.5f, 1.0f)  
        };
        static float time = 0.0f;
        time += 0.01f;
        int colorIndex = int(time) % 6;
        float lerpFactor = time - int(time);
        ImVec4 color1 = rainbowColors[colorIndex];
        ImVec4 color2 = rainbowColors[(colorIndex + 1) % 6];
        ImVec4 lerpedColor;
        lerpedColor.x = color1.x + lerpFactor * (color2.x - color1.x);
        lerpedColor.y = color1.y + lerpFactor * (color2.y - color1.y);
        lerpedColor.z = color1.z + lerpFactor * (color2.z - color1.z);
        lerpedColor.w = color1.w + lerpFactor * (color2.w - color1.w);
        ImGui::TextColored(lerpedColor, text);
    }
    	
    void RainbowBegin(const char* title, bool* p_opn, ImGuiWindowFlags flags) {
        ImVec4 rainbowColors[] = {
            ImVec4(1.0f, 0.0f, 0.0f, 1.0f),   
            ImVec4(1.0f, 0.5f, 0.0f, 1.0f),   
            ImVec4(1.0f, 1.0f, 0.0f, 1.0f),   
            ImVec4(0.0f, 1.0f, 0.0f, 1.0f),   
            ImVec4(0.0f, 0.0f, 1.0f, 1.0f),   
            ImVec4(0.5f, 0.0f, 0.5f, 1.0f)    
        };
        static float time = 0.0f;
        time += 0.01f;
        int colorIndex = int(time) % 6;
        float lerpFactor = time - int(time);
        ImVec4 color1 = rainbowColors[colorIndex];
        ImVec4 color2 = rainbowColors[(colorIndex + 1) % 6];
        ImVec4 lerpedColor;
        lerpedColor.x = color1.x + lerpFactor * (color2.x - color1.x);
        lerpedColor.y = color1.y + lerpFactor * (color2.y - color1.y);
        lerpedColor.z = color1.z + lerpFactor * (color2.z - color1.z);
        lerpedColor.w = color1.w + lerpFactor * (color2.w - color1.w);
        ImGui::PushStyleColor(ImGuiCol_Text, lerpedColor);
        ImGui::Begin(title, p_opn, flags);
        ImGui::PopStyleColor();
    }

    const ImVec4 col_bg_main       = ImVec4(0.04f, 0.06f, 0.11f, 1.0f);
    const ImVec4 col_bg_secondary  = ImVec4(0.07f, 0.09f, 0.15f, 1.0f);
    const ImVec4 col_bg_tertiary   = ImVec4(0.11f, 0.13f, 0.19f, 1.0f);
    const ImVec4 col_text_white    = ImVec4(1.00f, 1.00f, 1.00f, 1.00f);
    const ImVec4 col_text_gray     = ImVec4(0.63f, 0.65f, 0.71f, 1.00f);

    void SetupCheatGuiStyle() {
        ImGuiStyle& style = ImGui::GetStyle();
        style.WindowRounding    = 16.0f; 
        style.ChildRounding     = 12.0f;
        style.FrameRounding     = 8.0f;
        style.GrabRounding      = 12.0f; 
        style.PopupRounding     = 8.0f;
        style.ScrollbarRounding = 9.0f;
        style.WindowPadding     = ImVec2(0, 0); 
        style.FramePadding      = ImVec2(16, 16); 
        style.ItemSpacing       = ImVec2(12, 20); 
        style.ScrollbarSize     = 6.0f;
        style.TouchExtraPadding = ImVec2(5, 5); 

        style.Colors[ImGuiCol_WindowBg]         = col_bg_main;
        style.Colors[ImGuiCol_ChildBg]          = col_bg_main; 
        style.Colors[ImGuiCol_PopupBg]          = col_bg_tertiary;
        style.Colors[ImGuiCol_Text]             = col_text_white;
        style.Colors[ImGuiCol_TextDisabled]     = col_text_gray;
        style.Colors[ImGuiCol_Border]           = col_bg_tertiary;
        style.Colors[ImGuiCol_FrameBg]          = col_bg_tertiary;
        style.Colors[ImGuiCol_FrameBgHovered]   = ImVec4(0.15f, 0.18f, 0.25f, 1.0f);
        style.Colors[ImGuiCol_FrameBgActive]    = col_bg_tertiary;
        style.Colors[ImGuiCol_Button]           = col_bg_tertiary;
        style.Colors[ImGuiCol_ButtonHovered]    = accentcolor;
        style.Colors[ImGuiCol_ButtonActive]     = accentcolor;
        style.Colors[ImGuiCol_CheckMark]        = col_text_white; 
        style.Colors[ImGuiCol_SliderGrab]       = ImVec4(0.0f, 0.0f, 0.0f, 1.0f); 
        style.Colors[ImGuiCol_SliderGrabActive] = ImVec4(0.1f, 0.1f, 0.1f, 1.0f);
        style.Colors[ImGuiCol_Header]           = col_bg_tertiary;
        style.Colors[ImGuiCol_HeaderHovered]    = col_bg_secondary;
        style.Colors[ImGuiCol_HeaderActive]     = col_bg_secondary;
    }

    bool SidebarButton(const char* label, const char* icon, int tabIndex, bool active) {
        ImGuiWindow* window = ImGui::GetCurrentWindow();
        if (window->SkipItems) return false;
        ImGuiContext& g = *GImGui;
        const ImGuiStyle& style = g.Style;
        const ImGuiID id = window->GetID(label);
        const ImVec2 label_size = ImGui::CalcTextSize(label, NULL, true);

        ImVec2 size = ImVec2(ImGui::GetContentRegionAvail().x - 24, 80); 
        ImVec2 pos = window->DC.CursorPos;
        pos.x += 12; 

        const ImRect bb(pos, ImVec2(pos.x + size.x, pos.y + size.y));
        ImGui::ItemSize(size, style.FramePadding.y);
        if (!ImGui::ItemAdd(bb, id)) return false;

        bool hovered, held;
        bool pressed = ImGui::ButtonBehavior(bb, id, &hovered, &held);

        ImU32 bg_col;
        ImU32 text_col;
        ImU32 icon_col;
        
        if (active) {
            bg_col = ImGui::GetColorU32(col_bg_tertiary);
            text_col = ImGui::GetColorU32(accentcolor);
            icon_col = ImGui::GetColorU32(accentcolor);
        } else if (hovered) {
            bg_col = ImGui::GetColorU32(col_bg_tertiary); 
            text_col = ImGui::GetColorU32(col_text_white);
            icon_col = ImGui::GetColorU32(col_text_gray);
        } else {
            bg_col = ImGui::GetColorU32(col_bg_secondary); 
            text_col = ImGui::GetColorU32(col_text_gray);
            icon_col = ImGui::GetColorU32(col_text_gray);
        }
        
        window->DrawList->AddRectFilled(bb.Min, bb.Max, bg_col, 16.0f);
        if (active) {
            window->DrawList->AddRectFilled(ImVec2(bb.Max.x - 6, bb.Min.y + 15), ImVec2(bb.Max.x, bb.Max.y - 15), ImGui::GetColorU32(accentcolor), 4.0f, ImDrawFlags_RoundCornersLeft);
        }
        
        float content_h = label_size.y + 25; 
        float start_y = pos.y + (size.y - content_h) / 2;
        ImGui::PushStyleColor(ImGuiCol_Text, icon_col);
        ImVec2 icon_size = ImGui::CalcTextSize(icon);
        window->DrawList->AddText(ImVec2(pos.x + (size.x - icon_size.x)/2, start_y), icon_col, icon);
        ImVec2 text_pos = ImVec2(pos.x + (size.x - label_size.x)/2, start_y + 30);
        window->DrawList->AddText(text_pos, text_col, label);
        ImGui::PopStyleColor();
        return pressed;
    }
    
    bool CustomCheckbox(const char* label, bool* v) {
        ImGuiWindow* window = ImGui::GetCurrentWindow();
        if (window->SkipItems) return false;
        ImGuiContext& g = *GImGui;
        const ImGuiStyle& style = g.Style;
        const ImGuiID id = window->GetID(label);
        const ImVec2 label_size = ImGui::CalcTextSize(label, NULL, true);

        const float square_sz = 36.0f; 
        const ImVec2 pos = window->DC.CursorPos;
        const ImRect total_bb(pos, ImVec2(pos.x + square_sz + style.ItemInnerSpacing.x + label_size.x + 30, pos.y + square_sz));
        ImGui::ItemSize(total_bb, style.FramePadding.y);
        if (!ImGui::ItemAdd(total_bb, id)) return false;

        bool hovered, held;
        bool pressed = ImGui::ButtonBehavior(total_bb, id, &hovered, &held);
        if (pressed) *v = !(*v);

        ImU32 check_bg_col = *v ? ImGui::GetColorU32(accentcolor) : ImGui::GetColorU32(col_bg_tertiary);
        window->DrawList->AddRectFilled(pos, ImVec2(pos.x + square_sz, pos.y + square_sz), check_bg_col, 8.0f);

        if (*v) {
            ImU32 check_col = ImGui::GetColorU32(col_text_white);
            ImGui::RenderCheckMark(window->DrawList, ImVec2(pos.x + 6, pos.y + 6), check_col, square_sz - 12);
        }

        ImVec2 text_pos = ImVec2(pos.x + square_sz + 18, pos.y + (square_sz - label_size.y) / 2);
        ImU32 text_col = *v ? ImGui::GetColorU32(col_text_white) : ImGui::GetColorU32(col_text_gray);
        window->DrawList->AddText(text_pos, text_col, label);
        return pressed;
    }

    bool ModernSlider(const char* label, float* v, float v_min, float v_max, const char* format = "%.1f", const char* unit = "") {
        ImGui::PushStyleColor(ImGuiCol_Text, ImGui::GetColorU32(col_text_white));
        char value_buf[64];
        sprintf(value_buf, format, *v);
        ImGui::Text("%s", label);
        ImGui::SameLine();
        ImGui::PushStyleColor(ImGuiCol_Text, ImGui::GetColorU32(accentcolor));
        ImGui::Text("%s%s", value_buf, unit);
        ImGui::PopStyleColor();

        ImGuiWindow* window = ImGui::GetCurrentWindow();
        const ImGuiStyle& style = ImGui::GetStyle();
        const ImGuiID id = window->GetID(label);
        
        const float w = ImGui::GetContentRegionAvail().x - 30.0f;
        
        const float h = 12.0f; 
        const float thumb_sz = 28.0f; 

        ImVec2 pos = window->DC.CursorPos;
        pos.y += 8.0f; 
        
        const ImRect frame_bb(pos, ImVec2(pos.x + w, pos.y + thumb_sz)); 
        ImGui::ItemSize(frame_bb, style.FramePadding.y);
        if (!ImGui::ItemAdd(frame_bb, id)) {
            ImGui::PopStyleColor();
            return false;
        }

        bool hovered, held;
        bool pressed = ImGui::ButtonBehavior(frame_bb, id, &hovered, &held);
        if (hovered && ImGui::IsMouseDown(0)) {
            held = true;
            ImGui::SetActiveID(id, window);
        }

        if (held) {
            float mouse_x = ImGui::GetIO().MousePos.x;
            float normalized = (mouse_x - pos.x) / w;
            normalized = ImClamp(normalized, 0.0f, 1.0f);
            *v = v_min + normalized * (v_max - v_min);
        }

        float mid_y = pos.y + (thumb_sz / 2);
        window->DrawList->AddRectFilled(ImVec2(pos.x, mid_y - 3), ImVec2(pos.x + w, mid_y + 3), ImGui::GetColorU32(col_bg_tertiary), 3.0f);
        float t = (*v - v_min) / (v_max - v_min);
        if (t < 0.0f) t = 0.0f; if (t > 1.0f) t = 1.0f;
        float fill_w = w * t;
        window->DrawList->AddRectFilled(ImVec2(pos.x, mid_y - 3), ImVec2(pos.x + fill_w, mid_y + 3), ImGui::GetColorU32(accentcolor), 3.0f);
        float grab_x = pos.x + fill_w;
        window->DrawList->AddCircleFilled(ImVec2(grab_x, mid_y), thumb_sz/2 + 2, ImGui::GetColorU32(ImVec4(0,0,0,0.5f)));
        window->DrawList->AddCircleFilled(ImVec2(grab_x, mid_y), thumb_sz/2, ImGui::GetColorU32(accentcolor));
        window->DrawList->AddCircleFilled(ImVec2(grab_x, mid_y), (thumb_sz/2) - 5, IM_COL32(0,0,0,255));
        ImGui::PopStyleColor();
        return pressed;
    }
}

void ImGui_RunningText(const char* text, float speed, ImU32 textColor = 0)
{
    static float offset = 0.0f;
    static float textWidth = 0.0f;
    static bool initialized = false;
    if (!initialized) {
        ImGui::PushFont(ImGui::GetIO().Fonts->Fonts[0]);
        textWidth = ImGui::CalcTextSize(text).x;
        ImGui::PopFont();
        initialized = true;
    }
    offset -= speed;
    if (offset < -textWidth) offset = ImGui::GetWindowWidth();
    ImGui::SetCursorPosX(offset);
    ImVec4 color = (textColor == 0) ? ImGui::ColorConvertU32ToFloat4(ImGui::GetColorU32(ImGuiCol_Text)) : ImGui::ColorConvertU32ToFloat4(textColor);
    ImGui::TextColored(color, "%s", text);
}

string GetCurrentTime() {
    time_t currentTime = time(nullptr);
    tm* timeInfo = localtime(&currentTime);
    ostringstream oss;
    oss << put_time(timeInfo, "%Y-%m-%d %H:%M:%S");
    return oss.str();
}

int ConvertDateTimeToInt(const char* datetimeString) {
    tm timeInfo = {};
    istringstream ss(datetimeString);
    ss >> timeInfo.tm_year; ss.ignore();
    ss >> timeInfo.tm_mon; ss.ignore();
    ss >> timeInfo.tm_mday; ss.ignore();
    ss >> timeInfo.tm_hour; ss.ignore();
    ss >> timeInfo.tm_min; ss.ignore();
    ss >> timeInfo.tm_sec;
    timeInfo.tm_year -= 1900;
    timeInfo.tm_mon -= 1;
    return static_cast<int>(mktime(&timeInfo));
}

void MauYuim() { ImGuiX::SetupCheatGuiStyle(); }
void DrawImGuiStyle(){ ImGuiX::SetupCheatGuiStyle(); }

void KlelYuimimguivip1() {
    ImGuiIO& io = ImGui::GetIO();
    static const ImWchar icons_ranges[] = { 0xf000, 0xf3ff, 0 };
    ImFontConfig icons_config;    
    icons_config.MergeMode = true;
    icons_config.PixelSnapH = true;

    io.Fonts->AddFontFromFileTTF("static/Oswald-Regular.ttf", 28.0f); 
    io.Fonts->AddFontFromFileTTF("fonts/fa-solid-900.ttf", 28.0f, &icons_config, icons_ranges);
    io.Fonts->AddFontFromMemoryTTF(const_cast<std::uint8_t*>(Custom), sizeof(Custom), 35.f, NULL, io.Fonts->GetGlyphRangesVietnamese());
    io.Fonts->AddFontFromMemoryCompressedTTF(font_awesome_data, font_awesome_size, 30.0f, &icons_config, icons_ranges);
    
    // Key Mapping
    io.KeyMap[ImGuiKey_UpArrow] = 19;
    io.KeyMap[ImGuiKey_DownArrow] = 20;
    io.KeyMap[ImGuiKey_LeftArrow] = 21;
    io.KeyMap[ImGuiKey_RightArrow] = 22;
    io.KeyMap[ImGuiKey_Enter] = 66;
    io.KeyMap[ImGuiKey_Backspace] = 67;
    io.KeyMap[ImGuiKey_Escape] = 111;
    io.KeyMap[ImGuiKey_Delete] = 112;
    io.KeyMap[ImGuiKey_Home] = 122;
    io.KeyMap[ImGuiKey_End] = 123;
    
    ImGui_ImplOpenGL3_Init("#version 300 es");
    ImGui::GetStyle().ScaleAllSizes(3.5f); // Scale ใหญ่
    
    ImGuiX::SetupCheatGuiStyle(); 
};